"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildWhereClause = exports.parseIntOrThrow = void 0;
const parseIntOrThrow = (value, fieldName = 'ID') => {
    const parsed = parseInt(value, 10);
    if (isNaN(parsed)) {
        throw new Error(`${fieldName} must be a valid number`);
    }
    return parsed;
};
exports.parseIntOrThrow = parseIntOrThrow;
const buildWhereClause = (filters) => {
    const where = {};
    for (const key in filters) {
        if (filters[key] !== undefined && filters[key] !== null) {
            where[key] = filters[key];
        }
    }
    return where;
};
exports.buildWhereClause = buildWhereClause;
//# sourceMappingURL=database.helper.js.map